/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.CalendarHelper;
import cz.insophy.inplan.util.Triple;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportUtilities {
    private static final Logger LOG = LoggerFactory.getLogger(ReportUtilities.class);

    public static long getOverlap(long start1, long end1, long start2, long end2) {
        if (start1 > end1 || start2 > end2) {
            LOG.error("Cannot compute overlap of two invalid dates.");
            throw new IllegalArgumentException("Crossed dates.");
        }
        if (start1 > end2 || start2 > end1) {
            return 0L;
        }
        long overlap = Math.min(end1, end2) - Math.max(start1, start2);
        if (overlap < 0L) {
            LOG.error(String.format("Invalid result from overlapping: (%d-%d, %d-%d)", start1, end1, start2, end2));
            throw new IllegalStateException();
        }
        return overlap;
    }

    public static long getWorkplaceOnlineTime(Plan plan, Workplace workplace, long startDate, long endDate) {
        if (startDate >= endDate) {
            return 0L;
        }
        long remaining = endDate - startDate;
        for (WorkplaceActivity activity : plan.getWorkplaceSchedule(workplace).activities()) {
            if (!(activity instanceof OfflineActivity)) continue;
            remaining -= ReportUtilities.getOverlap(startDate, endDate, activity.getStart(), activity.getEnd());
        }
        if (remaining < 0L) {
            LOG.error("Invalid remaining time for the workplace: " + remaining);
            throw new IllegalStateException("Invalid remaining time for the workplace: " + remaining);
        }
        return remaining;
    }

    public static double getSafeRatio(double part, double whole) {
        if (part == 0.0 || Math.abs(part) <= 1.0E-7) {
            return 0.0;
        }
        if (whole == 0.0 || Math.abs(whole) <= 1.0E-7) {
            return Double.NaN;
        }
        return part / whole;
    }

    public static String stripHtml(String input) {
        int i = input.indexOf(60);
        if (i < 0) {
            return input;
        }
        int len = input.length();
        StringBuilder sb = new StringBuilder(len);
        sb.append(input, 0, i);
        ++i;
        StripState state = StripState.TAG;
        while (i < len) {
            switch (state) {
                case TEXT: {
                    int j = input.indexOf(60, i);
                    if (j < 0) {
                        j = len;
                    }
                    sb.append(input, i, j);
                    i = j + 1;
                    state = StripState.TAG;
                    break;
                }
                case TAG: {
                    char ch;
                    int tagNameStart;
                    boolean tagEnd = input.charAt(i) == '/';
                    int j = tagNameStart = tagEnd ? i + 1 : i;
                    while (Character.isLetterOrDigit(ch = input.charAt(j)) || ch == '-' || ch == '.' || ch == '_' || ch == ':') {
                        ++j;
                    }
                    String tagName = input.substring(tagNameStart, j);
                    j = input.indexOf(62, i);
                    if (j < 0) {
                        sb.append(input, i - 1, len);
                        i = len;
                        break;
                    }
                    if ((tagEnd |= input.charAt(j - 1) == '/') && (tagName.equals("td") || tagName.equals("dt") || tagName.equals("th")) && (j + 1 == len || j + 1 < len && input.charAt(j + 1) != ' ')) {
                        sb.append(' ');
                    } else if ((tagName.equals("br") || tagName.equals("p") || tagEnd && (tagName.equals("tr") || tagName.equals("li"))) && (j + 1 == len || j + 1 < len && input.charAt(j + 1) != '\n')) {
                        sb.append('\n');
                    }
                    i = j + 1;
                    state = StripState.TEXT;
                }
            }
        }
        return sb.toString();
    }

    public static Map<GeneralizedActionRequest, GeneralizedActionRequest> findPreviousGars(Iterable<GeneralizedActionRequest> gars) {
        HashMap<GeneralizedActionRequest, GeneralizedActionRequest> result = new HashMap<GeneralizedActionRequest, GeneralizedActionRequest>();
        block0: for (GeneralizedActionRequest gar : gars) {
            for (int i = 1; i < ((GeneralizedOrderRequest)gar.getParent()).getGars().size(); ++i) {
                GeneralizedActionRequest tgar = ((GeneralizedOrderRequest)gar.getParent()).getGars().get(i);
                if (tgar != gar) continue;
                result.put(gar, ((GeneralizedOrderRequest)gar.getParent()).getGars().get(i - 1));
                continue block0;
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public static long getDueDateWindowSize(GeneralizedOrderRequest gor) {
        return ReportUtilities.getWindowSize(gor.getReleaseDate(), gor.getStartDate(), gor.getDueDate());
    }

    public static long getEndDateWindowSize(GeneralizedOrderRequest gor) {
        return ReportUtilities.getWindowSize(gor.getReleaseDate(), gor.getStartDate(), gor.getEndDate());
    }

    public static long getWindowSize(long release, long start, long end) {
        long minstart = Math.min(release, start);
        return Math.max(0L, end - minstart);
    }

    public static long getGorDelay(GeneralizedOrderRequest gor) {
        long start = gor.getDueDate();
        long end = gor.getEndDate();
        return end - start;
    }

    public static long getStartTime(GeneralizedActionRequest gar, GeneralizedActionRequest prevGar) {
        if (prevGar == null || !GeneralizedRequest.isDateValid(prevGar.getEndDate())) {
            Preconditions.checkNotNull(gar.getParent());
            Preconditions.checkArgument(gar.getParent() instanceof GeneralizedOrderRequest);
            long garDate = gar.getStartDate();
            long gorDate = ((GeneralizedOrderRequest)gar.getParent()).getReleaseDate();
            return Math.min(gorDate, garDate);
        }
        return prevGar.getEndDate();
    }

    public static long getEndTime(GeneralizedActionRequest gar) {
        return gar.getEndDate();
    }

    public static long getTotalTime(GeneralizedActionRequest gar, GeneralizedActionRequest prevGar) {
        long start = ReportUtilities.getStartTime(gar, prevGar);
        long end = ReportUtilities.getEndTime(gar);
        return Math.max(0L, end - start);
    }

    public static long getProductionTime(GeneralizedActionRequest gar) {
        long sum = 0L;
        for (ActionActivity aa : gar.getActivities()) {
            sum += aa.getDuration();
        }
        return Math.max(0L, sum);
    }

    public static long getLogisticTime(GeneralizedActionRequest gar, GeneralizedActionRequest prevGar) {
        if (prevGar == null || !GeneralizedRequest.isDateValid(prevGar.getEndDate())) {
            return 0L;
        }
        return Math.max(0L, gar.getAction().getMinTimeToPrepare());
    }

    public static long getWaitingTime(GeneralizedActionRequest gar, GeneralizedActionRequest prevGar) {
        long total = ReportUtilities.getTotalTime(gar, prevGar);
        long production = ReportUtilities.getProductionTime(gar);
        long logistics = ReportUtilities.getLogisticTime(gar, prevGar);
        return Math.max(0L, total - production - logistics);
    }

    public static Actiongram getBestActiongram(GeneralizedOrderRequest gor) {
        Actiongram alternative = gor.getSelectedActiongram();
        if (alternative == null) {
            alternative = gor.getProduct().getDefaultActiongram();
        }
        return alternative;
    }

    public static long getDefaultReportStartTime(Superplan superplan) {
        long date = Calendar.getInstance().getTimeInMillis();
        if (superplan != null && !GeneralizedRequest.isDateValid(date = superplan.getFixationDate())) {
            date = superplan.getTimeBounds().getStart();
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date);
        return CalendarHelper.setDayStart(c).getTimeInMillis();
    }

    public static long getDefaultReportEndTime(Superplan superplan) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(ReportUtilities.getDefaultReportStartTime(superplan));
        calendar.add(5, 14);
        long date = calendar.getTimeInMillis();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date);
        return CalendarHelper.setDayEnd(c).getTimeInMillis();
    }

    public static List<Triple<String, String, PropertyDefinition.PropertyType>> propertiesAsString(Propertized item) {
        LinkedList<Triple> result = Lists.newLinkedList();
        for (Map.Entry<PropertyDefinition, Object> p : item.getProperties().entrySet()) {
            String title = p.getKey().getLabel();
            String value = ReportUtilities.propertyAsString(p.getKey(), p.getValue());
            PropertyDefinition.PropertyType type = p.getKey().getType();
            result.add(Triple.create(title, value, type));
        }
        result.sort(Comparator.comparing(Triple::getFirst));
        return Collections.unmodifiableList(result);
    }

    private static String propertyAsString(PropertyDefinition pdef, Object value) {
        if (value == null) {
            return "";
        }
        return pdef.getType().asString(value);
    }

    private ReportUtilities() {
    }

    private static enum StripState {
        TEXT,
        TAG;

    }
}

